package app.firezone.synk.network.Adapter;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.RecyclerView;

import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.YouTubePlayer;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.AbstractYouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.FullscreenListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.views.YouTubePlayerView;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.VideoLayoutBinding;
import app.firezone.synk.network.model.VideoModel;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import kotlin.Unit;
import kotlin.jvm.functions.Function0;

public class VideoAdapter extends RecyclerView.Adapter<VideoAdapter.holder> {

    Context mContext;
    ArrayList<VideoModel> list;
    LifecycleOwner lifecycleOwner;

    Dialog dialog;

    public VideoAdapter(Context mContext, ArrayList<VideoModel> list, LifecycleOwner lifecycleOwner) {
        this.mContext = mContext;
        this.list = list;
        this.lifecycleOwner = lifecycleOwner;
    }

    @NonNull
    @Override
    public VideoAdapter.holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.video_layout, parent, false);
        return new holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull holder holder, int position) {

        VideoModel model = list.get(position);

        // Set video title and animation
        holder.binding.videoText.setText(model.getDiscripation());
        Animation animation = AnimationUtils.loadAnimation(mContext, R.anim.text_slider);
        holder.binding.videoText.startAnimation(animation);
        holder.binding.videoText.setSelected(true);

        // Extract the YouTube video ID from the URL
        String videoUrl = model.getVideourl();
        String videoId = extractYouTubeVideoId(videoUrl);

        // Log video URL and videoId for debugging
        Log.d("VideoAdapter", "Video URL: " + videoUrl);
        Log.d("VideoAdapter", "Extracted Video ID: " + videoId);

        if (videoId == null) {
            // Handle the case where videoId is null
            Log.e("VideoAdapter", "Error: videoId is null for video URL: " + videoUrl);
            return;  // Avoid attempting to load the video if videoId is null
        }

        // YouTubePlayerView initialization
        YouTubePlayerView youTubePlayerView = holder.binding.youtubePlayerView;
        lifecycleOwner.getLifecycle().addObserver(youTubePlayerView);
       // youTubePlayerView.setEnableAutomaticInitialization(false);



        youTubePlayerView.addYouTubePlayerListener(new AbstractYouTubePlayerListener() {
            @Override
            public void onReady(@NonNull YouTubePlayer youTubePlayer) {
                youTubePlayer.cueVideo(videoId, 0);
            }
        });

        youTubePlayerView.addFullscreenListener(new FullscreenListener() {
            @Override
            public void onEnterFullscreen(@NonNull View fullscreenView, @NonNull Function0<Unit> exitFullscreen) {
            }

            @Override
            public void onExitFullscreen() {
            }
        });




        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                dialog = new Dialog(mContext);
                dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
                dialog.setContentView(R.layout.dialog_video_layout);


                ImageView cancelBtn = dialog.findViewById(R.id.cancelDialog);
                TextView videoTxt = dialog.findViewById(R.id.videoText2);
                videoTxt.setText(model.getDiscripation());

                YouTubePlayerView youTubePlayerView2 = dialog.findViewById(R.id.youtube_player_view2);
                lifecycleOwner.getLifecycle().addObserver(youTubePlayerView2);

                youTubePlayerView2.addYouTubePlayerListener(new AbstractYouTubePlayerListener() {
                    @Override
                    public void onReady(@NonNull YouTubePlayer youTubePlayer2) {
                        youTubePlayer2.cueVideo(videoId, 0);

                    }
                });

                youTubePlayerView2.addFullscreenListener(new FullscreenListener() {
                    @Override
                    public void onEnterFullscreen(@NonNull View view, @NonNull Function0<Unit> function0) {

                    }

                    @Override
                    public void onExitFullscreen() {

                    }
                });


                cancelBtn.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        dialog.dismiss();
                    }
                });

                dialog.show();
                dialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
                dialog.getWindow().getAttributes().windowAnimations = R.style.DialAnimation;
                dialog.getWindow().setGravity(Gravity.BOTTOM);

            }
        });
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    class holder extends RecyclerView.ViewHolder {
        VideoLayoutBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);
            binding = VideoLayoutBinding.bind(itemView);
        }
    }

    // Helper method to extract the YouTube video ID from a URL
    private String extractYouTubeVideoId(String videoUrl) {
        if (videoUrl == null || videoUrl.trim().isEmpty()) return null;

        // Updated regex to support: v=, /shorts/, /embed/, /live/, /v/, youtu.be/
        String regex = "(?:https?://)?(?:www\\.)?(?:youtube\\.com|youtu\\.be)/(?:watch\\?v=|shorts/|embed/|v/|live/|)([a-zA-Z0-9_-]{11})";

        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(videoUrl);

        if (matcher.find()) {
            return matcher.group(1); // Extracted Video ID
        }

        return null; // No valid ID found
    }


}

